<?php
namespace My\Plugin\Content\Shortcodes\Extension;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Event\Result\ResultAwareInterface;

class Shortcode extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
                'onContentPrepare' => 'replaceShortcodes',  
                'onContentAfterTitle' => 'addShortcodeSubtitle',  
                ];
    }

    // this will be called whenever the onContentPrepare event is triggered
    public function replaceShortcodes(Event $event)
    {
        /* This function processes the text of an article being presented on the site.
         * It replaces any text of the form "{configname}" (where configname is the name 
         * of a config parameter in configuration.php) with the value of the parameter.
         *
         * This is similar to shortcodes functionality within wordpress
         */

        // The line below restricts the functionality to the site (ie not on api)
        // You may not want this, so you need to consider this in your own plugins
        if (!$this->getApplication()->isClient('site')) {
            return;
        }
         
        // use this format to get the arguments for both Joomla 4 and Joomla 5
        // In Joomla 4 a generic Event is passed
        // In Joomla 5 a concrete ContentPrepareEvent is passed
        [$context, $article, $params, $page] = array_values($event->getArguments());
        if ($context !== "com_content.article" && $context !== "com_content.featured") return;
        
        $text = $article->text; // text of the article
        $config = Factory::getApplication()->getConfig()->toArray();  // config params as an array
            // (we can't do a foreach over the config params as a Registry because they're protected)
        
        // the following is just code to replace {configname} with the parameter value
        $offset = 0;
        // find opening curly brackets ...
        while (($start = strpos($text, "{", $offset)) !== false) {
            // find the corresponding closing bracket and extract the "shortcode"
            if ($end = strpos($text, "}", $start)) {
               $shortcode = substr($text, $start + 1, $end - $start - 1);
               
               // cycle through the config array looking for a match
               $match_found = false;
               foreach ($config as $key => $value) {
                   if ($key === $shortcode) {
                       $text = substr_replace($text, htmlspecialchars($value), $start, $end - $start + 1);
                       $match_found = true;
                       break;
                   }
                } 
                
                // if no match found replace it with an error string
                if (!$match_found) {
                    $this->loadLanguage();  // you need to load the plugin's language constants before using them
                    // (alternatively you can set:  protected $autoloadLanguage = true; and Joomla will load it for you)
                    $text = substr_replace($text, Text::_('PLG_CONTENT_SHORTCODES_NO_MATCH'), $start, $end - $start + 1);
                }
                
            } else {
               break;
            }
           
           $offset = $end;
        }

        // now update the article text with the processed text
        $article->text = $text;
    }
    
    public function addShortcodeSubtitle(Event $event)
    {
        if (!$this->getApplication()->isClient('site')) {
            return;
        }
        [$context, $article, $params, $page] = array_values($event->getArguments());
        if ($context !== "com_content.article" && $context !== "com_content.featured") return;
        
        $eventType = method_exists($event, 'getContext') ? "concrete event class" : "generic event class";
        
        if ($event instanceof ResultAwareInterface) {
            $event->addResult("{$eventType} via addResult");
        } else {
            $result = $event->getArgument('result') ?? [];
            $result[] = "{$eventType} via setArgument";
            $event->setArgument('result', $result);
        }
    }
}