<?php

namespace My\Plugin\System\CustomMenurule\Site\Service;

use Joomla\CMS\Component\Router\Rules\RulesInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Language\Multilanguage;

\defined('JPATH_PLATFORM') or die;

class MenuRules extends \Joomla\CMS\Component\Router\Rules\MenuRules
{
    private static $allLangHomeRemoved = false;

    public function preprocess(&$query)
    {
        $active = $this->router->menu->getActive();

        /**
         * If the active item id is not the same as the supplied item id or we have a supplied item id and no active
         * menu item then we just use the supplied menu item and continue
         */
        if (isset($query['Itemid']) && ($active === null || $query['Itemid'] != $active->id)) {
            return;
        }

        // Get query language
        $language = isset($query['lang']) ? $query['lang'] : '*';

        // Set the language to the current one when multilang is enabled and item is tagged to ALL
        if (Multilanguage::isEnabled() && $language === '*') {
            $language = $this->router->app->get('language');
        }

        // build the reverse lookup for the language (the buildLookup() for language "*" is already done in the constructor)
        // $this->lookup is a multidimensional array of the menuitems which match the component (com_content),
        // the language, and filtered by access.
        // It is keyed by:
        //   - firstly language - eg "*" or "en-GB"
        //   - secondly view or view:layout - the view, and possibly also layout, defined in the menuitem
        //   - thirdly id - whatever is the id defined in the menuitem, or 0 if no id is specified
        // The value of this element in the array is the Itemid of the menuitem.
        if (!isset($this->lookup[$language])) {
            $this->buildLookup($language);
        }
        
        // If the &Itemid=.. has been specified in the Route::_() call then use it if it's suitable 
        // (ie if it's in the lookup array)
        if (isset($query['Itemid'])) {
            if (array_search((int)$query['Itemid'], $this->lookup, true) !== false) {
                return; // just use that Itemid
            }
        }

        /* The following is superfluous given that we'll take the supplied menu item if it's found above
        // Check if the active menu item matches the requested query
        if ($active !== null && isset($query['Itemid'])) {
            // Check if active->query and supplied query are the same
            $match = true;

            foreach ($active->query as $k => $v) {
                if (isset($query[$k]) && $v !== $query[$k]) {
                    // Compare again without alias
                    if (\is_string($v) && $v == current(explode(':', $query[$k], 2))) {
                        continue;
                    }

                    $match = false;
                    break;
                }
            }

            if ($match) {
                // Just use the supplied menu item
                return;
            }
        }
        */

        // If it's a multilingual site then ensure we don't use the home page of the "*" language
        if (Multilanguage::isEnabled() && !self::$allLangHomeRemoved) {
            $homeItems = $this->router->menu->getItems(array('language', 'home'), array('*', 1));
            if ($homeItems) {
                $allLangHome = $homeItems[0]->id;
                foreach ($this->lookup as $lang => $viewArray) {
                    foreach ($viewArray as $view => $idArray) {
                        foreach ($idArray as $id => $itemid) {
                            if ($itemid == $allLangHome) {
                                if (count($this->lookup[$lang][$view]) == 1) {
                                    unset($this->lookup[$lang][$view]);
                                } else {
                                    unset($this->lookup[$lang][$view][$id]);
                                }
                                break;
                            }
                        }
                    }
                }
            }
            self::$allLangHomeRemoved = true;
        }
        
        // Form the equivalent of view:layout based on the query parameters, and try to match in the lookup array
        if (isset($query['view'])) {
            $searchKey = $query['view'];
            if (isset($query['layout']) && $query['layout'] !== 'default') {
                $searchKey .= ":" . $query['layout'];
            }
            foreach ($this->lookup as $lang => $arr) {
                if (array_key_exists($searchKey, $arr)) {  // find if there's a matching view:layout
                    $matchingViews = $arr[$searchKey];
                    // now see if we can find an exact match with the id
                    if (isset($query['id'])) {
                        $idKey = (int) $query['id'];
                        if (array_key_exists($idKey, $matchingViews)) {
                            $query['Itemid'] = $matchingViews[$idKey];
                            return;
                        } 
                    } else { // if we haven't got an id in the query array
                        if (array_key_exists(0, $matchingViews)) {
                            $query['Itemid'] = $matchingViews[0];
                            return;
                        } 
                    }
                }
            }
        }
        
        // Use the active menuitem if it's a com_content one 
        if ($active && $active->component === "com_content") {
            $query["Itemid"] = $active->id;
            return;
        }
        
        // if we didn't find one above, then fall back to the standard Joomla code below

        $needles = $this->router->getPath($query);

        $layout = isset($query['layout']) && $query['layout'] !== 'default' ? ':' . $query['layout'] : '';

        if ($needles) {
            foreach ($needles as $view => $ids) {
                $viewLayout = $view . $layout;

                if ($layout && isset($this->lookup[$language][$viewLayout])) {
                    if (\is_bool($ids)) {
                        $query['Itemid'] = $this->lookup[$language][$viewLayout];

                        return;
                    }

                    foreach ($ids as $id => $segment) {
                        if (isset($this->lookup[$language][$viewLayout][(int) $id])) {
                            $query['Itemid'] = $this->lookup[$language][$viewLayout][(int) $id];

                            return;
                        }
                    }
                }

                if (isset($this->lookup[$language][$view])) {
                    if (\is_bool($ids)) {
                        $query['Itemid'] = $this->lookup[$language][$view];

                        return;
                    }

                    foreach ($ids as $id => $segment) {
                        if (isset($this->lookup[$language][$view][(int) $id])) {
                            $query['Itemid'] = $this->lookup[$language][$view][(int) $id];

                            return;
                        }
                    }
                }
            }
        }

        // Check if the active menuitem matches the requested language
        if (
            $active && $active->component === 'com_' . $this->router->getName()
            && ($language === '*' || \in_array($active->language, ['*', $language]) || !Multilanguage::isEnabled())
        ) {
            $query['Itemid'] = $active->id;

            return;
        }

        // If not found, return language specific home link
        $default = $this->router->menu->getDefault($language);

        if (!empty($default->id)) {
            $query['Itemid'] = $default->id;
        }
    }

}
