<?php

namespace My\Plugin\System\CustomMenurule\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;

class CustomMenurulePlugin extends CMSPlugin implements SubscriberInterface {
     
    public static function getSubscribedEvents(): array {
        return [
            'onAfterExtensionBoot' => 'replaceRouterFactory',
        ];
    }

    public function replaceRouterFactory(Event $event): void {
        if (!$this->getApplication()->isClient("site")) {
            return;
        }
        [$subject, $type, $extensionName, $container] = array_values($event->getArguments());
        if (($type === ComponentInterface::class) && ($extensionName === "content")) {
            $container->registerServiceProvider(new RouterFactory('\\My\\Plugin\\System\\CustomMenurule'));
        }
    }
}