<?php

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use My\Plugin\System\CustomMenurule\Extension\CustomMenurulePlugin;
use Joomla\CMS\Factory;

return new class implements ServiceProviderInterface {

    public function register(Container $container) {
      $container->set(
        PluginInterface::class,
        function (Container $container) {
          $dispatcher = $container->get(DispatcherInterface::class);
          $plugin     = new CustomMenurulePlugin(
            $dispatcher,
            (array) PluginHelper::getPlugin('system', 'custom_menurule')
          );
          $plugin->setApplication(Factory::getApplication());
          return $plugin;
        }
      );
    }
};