<?php
namespace My\Plugin\Ajax\Ajaxdemo\Extension;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Result\ResultAwareInterface;
   
class Ajaxdemo extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
                'onAjaxDivide' => 'onAjaxDivide', 
                ];
    }
    
    public function onAjaxDivide(Event $event)
    {
        $app = $this->getApplication();
        $input = $app->input; 

        $a = $input->get("a", 0, "float");
        $b = $input->get("b", 0, "float");

        $answer = $this->_divide($a, $b);
        if ($event instanceof ResultAwareInterface) {
            $event->addResult($answer);
        } else {
            $result = $event->getArgument('result') ?? [];
            $result[] = $answer;
            $event->setArgument('result', $result);
        }
    }
    
    private function _divide($a, $b)  
    {
        if ($b == 0)
        {
            throw new \Exception('Division by zero!');
        }
        return $a/$b;
    }
}