<?php
namespace My\Plugin\Ajax\AjaxJobs\Extension;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Event\Result\ResultAwareInterface;
use Joomla\Database\DatabaseInterface;
   
class Jobs extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
                'onAjaxGetExtensionTotals' => 'onAjaxGetExtensionTotals', 
                ];
    }
    
    public function onAjaxGetExtensionTotals(Event $event)
    {
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        
        $query = $db->getQuery(true)
                ->select('type, count(*) as count')
                ->from($db->quoteName('#__extensions'))
                ->group('type');
        $db->setQuery($query);

        $counts = $db->loadAssocList('type', 'count');
        $output = "";
        foreach ($counts as $extension => $count) {
            $output .= "{$extension}:{$count}<br>";
        }

        if ($event instanceof ResultAwareInterface) {
            $event->addResult($output);
        } else {
            $result = $event->getArgument('result') ?? [];
            $result[] = $output;
            $event->setArgument('result', $result);
        }
    }
}