<?php
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\User\UserFactoryInterface;

$input = Factory::getApplication()->input;

// find the user - either from username=xxx parameter or current user
if ($input->exists('username'))
{
    $username = $input->get('username', "", "STRING");
    echo "Getting details for {$username}<br>";
    $user = Factory::getContainer()->get(UserFactoryInterface::class)->loadUserByUsername($username);
}
else
{
    $user = Factory::getApplication()->getIdentity();
}
if ($user->id == 0)
{
    echo "Please logon or provide a valid username as URL parameter";
    return;
}

// output the user's email address and Frontend language
$language = $user->getParam('language', 'the default');
echo "Email address of {$user->name} is {$user->email}, Frontend language is {$language}<br>";

// Set new Frontend language of this user if userlanguage=xxx parameter set
// This will fail if you try to change the language of a Super User, and you're not logged on as a Super User
if ($new_language = $input->get('userlanguage', "", "STRING"))
{
    if (array_key_exists($new_language, LanguageHelper::getContentLanguages()))
    {
        $user->setParam('language', $new_language);
        if ($user->save())
        {
            echo "Language successfully set to {$new_language}<br>";
        }
        else
        {
            echo "Setting language to {$new_language} failed<br>{$user->getError()}<br>";
        }
    }
    else
    {
        echo "Setting language to {$new_language} failed - language doesn't exist<br>";
    }
}

// if we're on a single article page, then check if the user can edit the article
$option = $input->get('option', "", "cmd");
$view = $input->get('view', "", "string");
$id = $input->get('id', 0, "int");

if ($option == "com_content" && $view == "article")
{
    if ($user->authorise('core.edit', "com_content.article.{$id}"))
    {
        echo "{$user->name} may edit this article<br>";
    }
    else
    {
        echo "{$user->name} may not edit this article<br>";
    }
}