<?php
namespace My\Component\Sqlfield\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class SqlfieldModel extends \Joomla\CMS\MVC\Model\FormModel
{

    public function getForm($data = array(), $loadData = true)
    {
        $form = $this->loadForm(
            'com_sqlfield.example',
            'example_form',
            array(
                'control' => 'jform',
                'load_data' => $loadData
            )
        );

        if (empty($form))
        {
            $errors = $this->getErrors();
            throw new \Exception(implode("\n", $errors), 500);
        }

        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState(
            'com_sqlfield.example',
            array() 
        );

        return $data;
    }

}