<?php
namespace My\Component\Sqlfield\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

class SqlfieldController extends FormController
{
    public function submit($key = null, $urlVar = null)
    {
        $this->checkToken();

        $app   = Factory::getApplication();
        $model = $this->getModel('sqlfield');
        $form = $model->getForm(null, false);
        if (!$form)
        {
            $app->enqueueMessage($model->getError(), 'error');
            return false;
        }

        $data  = $this->input->post->get('jform', array(), 'array');

        $validData = $model->validate($form, $data);

        if ($validData === false)
        {
            $errors = $model->getErrors();

            foreach ($errors as $error)
            {
                if ($error instanceof \Exception)
                {
                    $app->enqueueMessage($error->getMessage(), 'warning');
                }
                else
                {
                    $app->enqueueMessage($error, 'warning');
                }
            }

            $app->setUserState('com_sqlfield.example', $data);
            
            $this->setRedirect(Route::_('index.php?option=com_sqlfield', false));
        }
        else
        {
            $app->enqueueMessage("Data successfully validated", 'notice');

            $app->setUserState('com_sqlfield.example', null);

            $view = $this->getView('sqlfieldReturn', 'html');
            $view->setData($data, $validData);
            $view->display();
        }
    }
    
    public function reload($key = null, $urlVar = null)
    {
        $this->checkToken();

        $app   = Factory::getApplication();

        $data  = $this->input->post->get('jform', array(), 'array');
        $app->setUserState('com_sqlfield.example', $data);
        
        $model = $this->getModel('sqlfield');
        $view = $this->getView('sqlfield', 'html');
        $view->setModel($model, true);
        
        $view->display();
    }
}