<?php

namespace Mycompany\Component\Sampleff\Site\Field;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Form\FormField;

/**
 * Form Field class for capturing IATA airport code
 * This approach extends FormField and overrides getInput and getLabel
 */
class Custom1Field extends FormField
{
    protected function getInput()
    {
        $html = "<input type='text' id='{$this->id}' name='{$this->name}' " .
                "minlength='3' maxlength='3' size='3' " .
                "oninput='this.value = this.value.toUpperCase()'/>";
        return $html;
    }
    
    protected function getLabel()
    {
        $html = "Enter the <a href='https://wikipedia.org/wiki/IATA_airport_code' target='_blank'>" .
                "3 character IATA airport code</a>";
        return $html;
    }
}