<?php
namespace Mycompany\Component\Sampleff\Site\Controller;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

class PostController extends BaseController
{
	public function submit($key = null, $urlVar = null)
	{
		$this->checkToken();

		$app = Factory::getApplication();
		$model = $this->getModel('sample');
		$form = $model->getForm(null, false);
		if (!$form)
		{
			$app->enqueueMessage($model->getError(), 'error');
			return false;
		}

		// name of array 'jform' must match 'control' => 'jform' line in the model code
		$data  = $this->input->post->get('jform', array(), 'array');
        
        // store this in the session so that we can display it in DisplayController
        $app->setUserState('com_sample_form_field.post', $data);

		// This is validate() from the FormModel class, not the Form class
		// FormModel::validate() calls both Form::filter() and Form::validate() methods
		$validData = $model->validate($form, $data);

		if ($validData === false)
		{
			$errors = $model->getErrors();

			foreach ($errors as $error)
			{
				if ($error instanceof \Exception)
				{
					$app->enqueueMessage($error->getMessage(), 'warning');
				}
				else
				{
					$app->enqueueMessage($error, 'warning');
				}
			}

			// Save the form data in the session, using a unique identifier
			$app->setUserState('com_sample_form_field.sample', $data);
		}
		else
		{
			$app->enqueueMessage("Data successfully validated", 'notice');
			// Clear the form data in the session
			$app->setUserState('com_sample_form_field.sample', null);
		}

		// Redirect back to the DisplayController in all cases
		$this->setRedirect(Route::_('index.php?option=com_sample_form_field', false));
	}
}