<?php
namespace Mycompany\Component\SampleForm3\Site\Extension;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Dispatcher\DispatcherInterface;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\Input\Input;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

class SampleFormComponent implements ComponentInterface, ComponentDispatcherFactoryInterface, DispatcherInterface
{
    public function getDispatcher(CMSApplicationInterface $application): DispatcherInterface
    {
        return $this;
    }
    
    public function createDispatcher(CMSApplicationInterface $application, Input $input = null): DispatcherInterface
    {
        return $this;
    }
    
    public function dispatch()
    {
        $form = Factory::getContainer()->get(FormFactoryInterface::class)->createForm("sample", array("control" => "myform"));
        $formDirectory = JPATH_SITE . '/components/com_sample_form3/forms';
        $form->loadFile($formDirectory . "/sample_form.xml");
        
        // because email and telephone are within the "details" group, prefill data needs to reflect that
        $prefillData = array("details" => array("email" => ".@.", "telephone" => "0"), "time" => "12:34");

        // add form path so that Joomla can find the extra form 
        Form::addFormPath($formDirectory . "/extra");

        // using xpath parameter include just the "time" field from extra_form.xml, not the "ignored" field
        $extraForm = $form->loadFile("extra_form", true, "//field[@name='time']");

        // add a new element to the form, into "details" group and "mainFieldset" fieldset
        $xml = new \SimpleXMLElement('<field name="upload" type="file" label="Photo" accept="image/*" />');
        $form->setField($xml, 'details', true, "mainFieldset");

        // Change label on message field to say "Description" and set hint (html placeholder) to be "No asterisks!"
        $form->setFieldAttribute("message", "label", "Description");
        $form->setFieldAttribute("message", "hint", "No asterisks!");

        // Remove telephone field - uncomment line below to activate
        // $form->removeField("telephone", "details");

        // Some reflection methods
        echo "<h2>Reflection methods output</h2>";

        $formName = $form->getAttribute("name");
        echo "Form name is: $formName<br>";

        $formControl = $form->getFormControl();
        echo "Form control is: $formControl<br>";

        $detailsGroup = $form->getGroup('details');
        echo "Fields in details group: <br>";
        foreach ($detailsGroup as $key => $value)
        {
            echo "Key is: $key, PHP class of field is " . get_class($value) . ", and name attribute is " . $value->getAttribute("name") . "<br>";
        }

        $fieldsets = $form->getFieldsets();
        echo "Fieldset label for mainFieldset is " . $fieldsets['mainFieldset']->label . "<br>";

        if ($_SERVER['REQUEST_METHOD'] === 'POST') 
        {
            $app   = Factory::getApplication();
            $data = $app->input->post->get('myform', array(), "array");
            echo "<h2>POST data</h2>";
            echo "Message was " . $data["message"] . 
                ", email was " . $data["details"]["email"] . 
                ", and time was " . $data["time"] . "<br>";
            $filteredData = $form->filter($data);
            $result = $form->validate($filteredData);
            if ($result)
            {
                echo "Validation passed ok<br>";
            }
            else
            {
                echo "Validation failed<br>";
                $errors = $form->getErrors();
                foreach ($errors as $error)
                {
                    echo $error->getMessage() . "<br>";
                }
                // in the redisplayed form show what the user entered (after data is filtered)
                $prefillData = $filteredData;
            }
        }

        $form->bind($prefillData);
        $data = $form->getData();
        echo "<br>Form data is: $data<br>";

        ?>
        <form action="<?php echo Route::_('index.php?option=com_sample_form3'); ?>"
            method="post" name="sampleForm" id="adminForm" enctype="multipart/form-data">

            <h2>mainFieldset fieldset</h2>
            <?php echo $form->renderFieldset('mainFieldset');  ?>
            
            <h2>time field</h2>
            <?php echo $form->renderField('time');  ?>
            
            <h2>ignored field - should be blank</h2>
            <?php echo $form->renderField('ignored');  ?>
            
            <button type="submit">Submit</button>
        </form>
        <?php
    }
}